﻿    /* Skrypt pochodzi z książki
        "Dynamiczny HTML. 101 praktycznych skryptów"  */
    /* autor: Marcin Lis       http://marcinlis.com */

      var draggedDiv = null;
      var offset = null;

      document.onmouseup = mouseUp;
      document.onmousemove = mouseMove;

      function mousePos(evt)
      {
        evt = evt || window.event;

        if(evt.pageX){
          return {x:evt.pageX, y:evt.pageY};
        }
        else if(evt.clientX){
          return{
            x:evt.clientX + document.body.scrollLeft + document.body.clientLeft,
            y:evt.clientY + document.body.scrollTop  - document.body.clientTop
          };
        }
        else{
          return {x:0, y:0};
        }
      }

      function startDrag(obj)
      {
        if(!obj) return;
        draggedDiv = obj;
        xOff = 0;
        yOff = 0;
        while(obj.offsetParent){
          xOff += obj.offsetLeft;
          yOff += obj.offsetTop;
          obj = obj.offsetParent;
        }
  
        obj.onmousedown = function(evt)
        {
          coords = mousePos(evt);
          xOff = coords.x - xOff;
          yOff = coords.y - yOff; 
          offset = {x:xOff, y:yOff};
        }
      }

      function mouseUp(evt)
      {
        draggedDiv = null;
      }

      function mouseMove(evt)
      {
        coords = mousePos(evt);

        if(draggedDiv){
          draggedDiv.style.position = "absolute";
          draggedDiv.style.top = (coords.y - offset.y) + "px";
          draggedDiv.style.left = (coords.x - offset.x) + "px";
          return false;
        }
      }
      function rokPrzestepny(rok)
      {
        return ((rok % 4 == 0) && ((rok % 100 != 0) || (rok % 400 == 0)));
      }
      function wyświetlKalendarz(el)
      {
        data = new Date();

        var rok = data.getYear();
        if (rok < 1000) rok = 2000 + rok - 100;

        var miesiac = data.getMonth() + 1;
        var dzienTygodnia = data.getDay();
        var dzienMiesiaca = data.getDate();

        var tempDate = new Date(rok, miesiac - 1, 1);
        var pierwszyDzienMiesiaca = tempDate.getDay();

        if(dzienTygodnia == 0) dzienTygodnia = 7;
        if(pierwszyDzienMiesiaca == 0) pierwszyDzienMiesiaca = 7;

        switch(miesiac){
          case 1 : nazwaMiesiaca = "Styczeń";
                   dniWMiesiacu = 31;
                   break;
          case 2 : nazwaMiesiaca = "Luty";
                   dniWMiesiacu = rokPrzestepny(rok)?29:28;
                   break;
          case 3 : nazwaMiesiaca = "Marzec";
                   dniWMiesiacu = 31;
                   break;
          case 4 : nazwaMiesiaca = "Kwiecień";
                   dniWMiesiacu = 30;
                   break;
          case 5 : nazwaMiesiaca = "Maj";
                   dniWMiesiacu = 31;
                   break;
          case 6 : nazwaMiesiaca = "Czerwiec";
                   dniWMiesiacu = 30;
                   break;
          case 7 : nazwaMiesiaca = "Lipiec";
                   dniWMiesiacu = 31;
                   break;
          case 8 : nazwaMiesiaca = "Sierpień";
                   dniWMiesiacu = 31;
                   break;
          case 9 : nazwaMiesiaca = "Wrzesień";
                   dniWMiesiacu = 30;
                   break;
          case 10 : nazwaMiesiaca = "Październik";
                   dniWMiesiacu = 31;
                   break;
          case 11 : nazwaMiesiaca = "Listopad";
                   dniWMiesiacu = 30;
                   break;
          case 12 : nazwaMiesiaca = "Grudzień";
                   dniWMiesiacu = 31;
                   break;
        }
        
        var str = "";

        str += "<table border='1'><tr>";
        str += "<td class='tdNaglowek' colspan='7'>";
        str += nazwaMiesiaca + " " + rok;
        str += "<\/td><\/tr>";

        str += "<tr class='trNazwyDni'>";
        str += "<td>Pn<\/td>";
        str += "<td>Wt<\/td>";
        str += "<td>Śr<\/td>";
        str += "<td>Cz<\/td>";
        str += "<td>Pi<\/td>";
        str += "<td>So<\/td>";
        str += "<td>Nd<\/td>";
        str += "<\/tr><tr>";

        var j = dniWMiesiacu + pierwszyDzienMiesiaca - 1;

        for(var i = 0; i < j; i++){
          if(i < pierwszyDzienMiesiaca - 1){
            str += "<td class='tdEmpty'><\/td>";
            continue;
          }
          if((i % 7) == 0){
            str += "<\/tr><tr>";
          }
          var klasa = "tdDzien";
          if((i - pierwszyDzienMiesiaca + 2) == dzienMiesiaca){
            klasa = "tdBiezacyDzien";
          }
          str += "<td class='" + klasa + "'>";
          str += i - pierwszyDzienMiesiaca + 2;
          str += "<\/td>";
        }
        str += "<\/tr><\/table>";
        
        var el = document.getElementById(el);
        if(el) el.innerHTML = str;
      }